/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class PurgatoryModifier
extends Modifier
implements ConditionalStatModifierHook {
    public boolean isNetherDimension(Entity entity) {
        return entity != null && this.isNetherDimension(entity.f_19853_);
    }

    public boolean isNetherDimension(Level level) {
        return level.m_46472_().equals((Object)Level.f_46429_);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        if (context.getLivingTarget() != null) {
            LivingEntity target = context.getLivingTarget();
            if (this.isNetherDimension(target.f_19853_)) {
                return damage * 1.08f * (float)level;
            }
        }
        return damage;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (this.isNetherDimension((Entity)event.getPlayer())) {
            event.setNewSpeed(event.getNewSpeed() * 1.08f * (float)level);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        int level = modifier.getLevel();
        if (this.isNetherDimension((Entity)living) && stat == ToolStats.DRAW_SPEED) {
            return baseValue * 1.08f * (float)level;
        }
        return baseValue;
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        if (player != null && this.isNetherDimension((Entity)player)) {
            this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.modifier.purgatory.attack_damage"), 0.08f * (float)level, tooltip);
            this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.modifier.purgatory.mining_speed"), 0.08f * (float)level, tooltip);
        }
    }
}

